/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
Sound sound;      // sound
Vec   pos(0,0,3); // sound position
/******************************************************************************/
void InitPre()
{
   App.name="Sound 3D";
   App.flag=APP_NO_FX|APP_MS_EXCLUSIVE;
   PakAdd("../data/engine.pak");
}
/******************************************************************************/
Bool Init()
{
   sound.play("../data/sound/water.ogg",pos,1,true); // play looped 3D sound, volume=1, position=pos
   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   CamHandle(0.1,10,CAMH_ZOOM|CAMH_ROT);

   // update all 3D sound positions
   {
      sound.pos(pos); // since 'pos' is the same in each frame, you don't have to update it
   }

   // update listener parameters
   {
      ListenerPos(Cam.matrix.pos           ); // set listener position    (from camera)
      ListenerOrn(Cam.matrix.z,Cam.matrix.y); // set listener orientation (from camera)
      ListenerUpd(                         ); // updates all 3D parameters, only after this call all changes take effect
   }
   return true;
}
/******************************************************************************/
void Draw()
{
   D.clear(WHITE);
   Ball(1,pos).draw(BLACK); // draw ball at sound position
}
/******************************************************************************/
